/*
 * Decompiled with CFR 0.152.
 */
package questsadditions.rewards;

import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import questsadditions.rewards.RepeatableReward;
import questsadditions.rewards.RewardsRegistry;

public class RandomRepeatableReward
extends RepeatableReward {
    public RandomRepeatableReward(Quest quest) {
        super(quest);
    }

    @Override
    protected void claim(RewardTable table, ServerPlayer player) {
        for (WeightedReward reward : table.rewards) {
            if (reward.weight != 0) continue;
            reward.reward.claim(player, false);
        }
        int totalWeight = table.getTotalWeight(false);
        if (totalWeight <= 0) {
            return;
        }
        int number = player.f_19853_.f_46441_.nextInt(totalWeight) + 1;
        int currentWeight = 0;
        for (WeightedReward reward : table.rewards) {
            if ((currentWeight += reward.weight) < number) continue;
            reward.reward.claim(player, false);
            return;
        }
    }

    @Override
    public RewardType getType() {
        return RewardsRegistry.REPEAT_RANDOM;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addMouseOverText(TooltipList list) {
        if (this.getTable() != null) {
            this.getTable().addMouseOverText(list, true, false);
        }
    }
}

